#version 330

uniform sampler2D Tex0;
#ifdef _SOFT
uniform sampler2D color0Tex;
uniform float farClip;
#endif

in vec4 vcolor;
#ifdef _SOFT
in vec3 uv;
in vec4 clipPos;
#else
in vec2 uv;
#endif

out vec4 oColor;

#ifdef _SOFT
vec2 toScreen(vec4 ndPos)
{
	return ndPos.xy*vec2(0.5, -0.5) + vec2(0.5, 0.5);
}
#endif

void main()
{
	oColor = texture(Tex0, uv.xy)*vcolor;
#ifdef _SOFT
	vec2 screenUv = toScreen(clipPos/clipPos.w);
	vec4 normalDepth = textureLod(color0Tex, screenUv, 0);
	
	if(normalDepth.z != 0 && normalDepth.z > uv.z) {
		float diff = (normalDepth.z - uv.z)*farClip;
		const float factor = 5.0;
#ifdef _ADDITIVE
		oColor.rgb *= 1.0 - clamp(diff*factor, 0.0, 1.0);
#else
		oColor.a *= 1.0 - clamp(diff*factor, 0.0, 1.0);
#endif
	}
#endif
}
